<?php

/*
 * Plugin Name: Quform Limited Cookie
 * Description: Stops the Quform cookie being set until it is required.
 * Version: 1.0.0
 */

add_action('plugins_loaded', function () {
    if (class_exists('Quform')) {
        $session = quform('session');
        $enabled = false;

        if (wp_doing_ajax()) {
            $action = isset($_GET['action']) ? sanitize_text_field(wp_unslash($_GET['action'])) : '';

            if (in_array($action, array('quform_support_page_caching', 'quform_regenerate_captcha'), true)) {
                $enabled = true;
            }
        } elseif (Quform::isPostRequest() && isset($_POST['quform_form_id'])) {
            $enabled = true;
        }

        if (!$enabled) {
            remove_action('init', array($session, 'start'), 5);
            remove_action('shutdown', array($session, 'save'));
        }
    }
}, 20);
